/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	AlchemyTable
**
** DESCRIPTION:	Alchemy table puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ALCHEMYTABLE_H
#define ALCHEMYTABLE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "PuzzleInterface.h"
#include "../Collectables/CollectableInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int AlchemyTable_c_iNumIngredients = 3;
const int AlchemyTable_c_iResetTime = 5 * 60;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CAlchemyTable : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class structures
	struct SSaveState
	{
	};

	//class data
	unsigned int	m_uiResetTime;

	ECarrying		m_eIngredient[AlchemyTable_c_iNumIngredients];
	int				m_iNumIngredients;
	int				m_iAlchemistRef;

	ldwImageGrid *	m_pCarriedItems;

	//class methods
	//setup
	public:		CAlchemyTable(void);
	public:		void Reset();
	public:		void ResetAll();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Update();
	public:		void Complete();

	public:		void StartResetTimer();

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const ECarrying GetIngredient(const int iIngredient) const { return m_eIngredient[iIngredient]; }
	public:		const bool ContainsEnoughIngredients() const;
	public:		const int IngredientsRequired() const;
	public:		const bool IsAlchemistPresent() const;
	public:		CVillager & Alchemist() const;
	public:		const int SecondsUntilReset() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CAlchemyTable		AlchemyTable;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/